pdf_datei<-"original/zeitreihen_tageswerte_wochensymbole_negativ_3x1.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=8.27)
source("skripte/0inc_datendesign_grundeinstellungen.r")
par(mfcol=c(3,1),cex.axis=1.4,omi=c(1,0.5,0.75,0.5),
	mai=c(0.1,0.2,0.1,0.2),family="Lato Light",las=1) 

# Daten einlesen und Grafik vorbereiten

land<-c("US","GB","DE")
landbezeichnung<-c("USA","Großbritannien","Deutschland")
for (i in 1:length(land)) 
{
datei<-paste("daten/Facebook Happiness Index-",land[i],".csv",sep="")
daten<-read.csv(datei,skip=1)
daten$x<-as.Date(daten$Date)
daten<-subset(daten,daten$x>"2010-10-01")

# Grafik definieren

plot(daten$x,daten$GNH,type="n",axes=F,ylab="",ylim=c(-0.05,0.4))

# weitere Elemente

points(daten$x,daten$GNH,type="l")
daten$jahr<-as.numeric(format(daten$x,"%Y"))
daten$kw<-as.numeric(format(daten$x,"%V"))
neudaten<-daten[order(daten$jahr,daten$kw,-daten$GNH),]
tag<-NULL
farbe<-NULL
n<-nrow(neudaten)-1
for (j in 1:n) 
{
if(neudaten$kw[j+1] != neudaten$kw[j]) 
{
	tag<-c(tag,as.character(neudaten$x[j]))
	farbe<-c(farbe,weekdays(as.Date(as.character(neudaten$x[j]))))
}
}
farbe<-as.numeric(as.factor(farbe))
points(as.Date(tag),rep(-0.05,length(tag)),pch=15,cex=1.5,col=farbe)
mtext(landbezeichnung[i],3,line=-3,adj=0,cex=1.3,col="grey")
source("skripte/inc_tageswerte_wochensymbole_datumsbeschriftungen.r")
}
axis(1,at=daten$x[c(1,length(daten$x))],
	labels=format(daten$x[c(1,length(daten$x))],"%d. %b. %Y "))

# Betitelung

mtext("Facebook Gross National Happiness Index",3,line=1,adj=0,cex=2,
	col="grey",outer=T)
dev.off()
